/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1ValidatingWebhook;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "webhooks"})
public class V1ValidatingWebhookConfiguration
implements KubernetesObject {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_WEBHOOKS = "webhooks";
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="webhooks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ValidatingWebhook> webhooks;

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ValidatingWebhookConfiguration apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ValidatingWebhookConfiguration kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ValidatingWebhookConfiguration metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid V1ValidatingWebhook> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(List<@Valid V1ValidatingWebhook> webhooks) {
        this.webhooks = webhooks;
    }

    public V1ValidatingWebhookConfiguration webhooks(List<@Valid V1ValidatingWebhook> webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    public V1ValidatingWebhookConfiguration addWebhooksItem(V1ValidatingWebhook webhooksItem) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1ValidatingWebhook>();
        }
        this.webhooks.add(webhooksItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ValidatingWebhookConfiguration v1ValidatingWebhookConfiguration = (V1ValidatingWebhookConfiguration)o;
        return Objects.equals(this.apiVersion, v1ValidatingWebhookConfiguration.apiVersion) && Objects.equals(this.kind, v1ValidatingWebhookConfiguration.kind) && Objects.equals(this.metadata, v1ValidatingWebhookConfiguration.metadata) && Objects.equals(this.webhooks, v1ValidatingWebhookConfiguration.webhooks);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks);
    }

    public String toString() {
        return "V1ValidatingWebhookConfiguration(apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", webhooks: " + this.getWebhooks() + ")";
    }
}

