/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeError;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"attached", "attachError", "attachmentMetadata", "detachError"})
public class V1VolumeAttachmentStatus {
    public static final String JSON_PROPERTY_ATTACHED = "attached";
    public static final String JSON_PROPERTY_ATTACH_ERROR = "attachError";
    public static final String JSON_PROPERTY_ATTACHMENT_METADATA = "attachmentMetadata";
    public static final String JSON_PROPERTY_DETACH_ERROR = "detachError";
    @NotNull
    @JsonProperty(value="attached")
    private Boolean attached;
    @Nullable
    @Valid
    @JsonProperty(value="attachError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1VolumeError attachError;
    @Nullable
    @JsonProperty(value="attachmentMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> attachmentMetadata;
    @Nullable
    @Valid
    @JsonProperty(value="detachError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1VolumeError detachError;

    public V1VolumeAttachmentStatus(Boolean attached) {
        this.attached = attached;
    }

    public Boolean getAttached() {
        return this.attached;
    }

    public void setAttached(Boolean attached) {
        this.attached = attached;
    }

    public V1VolumeAttachmentStatus attached(Boolean attached) {
        this.attached = attached;
        return this;
    }

    public V1VolumeError getAttachError() {
        return this.attachError;
    }

    public void setAttachError(V1VolumeError attachError) {
        this.attachError = attachError;
    }

    public V1VolumeAttachmentStatus attachError(V1VolumeError attachError) {
        this.attachError = attachError;
        return this;
    }

    public Map<String, @NotNull String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public void setAttachmentMetadata(Map<String, @NotNull String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
    }

    public V1VolumeAttachmentStatus attachmentMetadata(Map<String, @NotNull String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
        return this;
    }

    public V1VolumeAttachmentStatus putAttachmentMetadataItem(String key, String attachmentMetadataItem) {
        if (this.attachmentMetadata == null) {
            this.attachmentMetadata = new HashMap<String, String>();
        }
        this.attachmentMetadata.put(key, attachmentMetadataItem);
        return this;
    }

    public V1VolumeError getDetachError() {
        return this.detachError;
    }

    public void setDetachError(V1VolumeError detachError) {
        this.detachError = detachError;
    }

    public V1VolumeAttachmentStatus detachError(V1VolumeError detachError) {
        this.detachError = detachError;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeAttachmentStatus v1VolumeAttachmentStatus = (V1VolumeAttachmentStatus)o;
        return Objects.equals(this.attached, v1VolumeAttachmentStatus.attached) && Objects.equals(this.attachError, v1VolumeAttachmentStatus.attachError) && Objects.equals(this.attachmentMetadata, v1VolumeAttachmentStatus.attachmentMetadata) && Objects.equals(this.detachError, v1VolumeAttachmentStatus.detachError);
    }

    public int hashCode() {
        return Objects.hash(this.attached, this.attachError, this.attachmentMetadata, this.detachError);
    }

    public String toString() {
        return "V1VolumeAttachmentStatus(attached: " + this.getAttached() + ", attachError: " + this.getAttachError() + ", attachmentMetadata: " + this.getAttachmentMetadata() + ", detachError: " + this.getDetachError() + ")";
    }
}

