/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"leaseName", "preferredStrategies", "binaryVersion", "emulationVersion", "pingTime", "renewTime"})
public class V1alpha1LeaseCandidateSpec {
    public static final String JSON_PROPERTY_LEASE_NAME = "leaseName";
    public static final String JSON_PROPERTY_PREFERRED_STRATEGIES = "preferredStrategies";
    public static final String JSON_PROPERTY_BINARY_VERSION = "binaryVersion";
    public static final String JSON_PROPERTY_EMULATION_VERSION = "emulationVersion";
    public static final String JSON_PROPERTY_PING_TIME = "pingTime";
    public static final String JSON_PROPERTY_RENEW_TIME = "renewTime";
    @NotNull
    @JsonProperty(value="leaseName")
    private String leaseName;
    @NotNull
    @JsonProperty(value="preferredStrategies")
    private @NotNull List<@NotNull String> preferredStrategies;
    @Nullable
    @JsonProperty(value="binaryVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String binaryVersion;
    @Nullable
    @JsonProperty(value="emulationVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String emulationVersion;
    @Nullable
    @JsonProperty(value="pingTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'")
    private OffsetDateTime pingTime;
    @Nullable
    @JsonProperty(value="renewTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'")
    private OffsetDateTime renewTime;

    public V1alpha1LeaseCandidateSpec(String leaseName, List<@NotNull String> preferredStrategies) {
        this.leaseName = leaseName;
        this.preferredStrategies = preferredStrategies;
    }

    public String getLeaseName() {
        return this.leaseName;
    }

    public void setLeaseName(String leaseName) {
        this.leaseName = leaseName;
    }

    public V1alpha1LeaseCandidateSpec leaseName(String leaseName) {
        this.leaseName = leaseName;
        return this;
    }

    public List<@NotNull String> getPreferredStrategies() {
        return this.preferredStrategies;
    }

    public void setPreferredStrategies(List<@NotNull String> preferredStrategies) {
        this.preferredStrategies = preferredStrategies;
    }

    public V1alpha1LeaseCandidateSpec preferredStrategies(List<@NotNull String> preferredStrategies) {
        this.preferredStrategies = preferredStrategies;
        return this;
    }

    public V1alpha1LeaseCandidateSpec addPreferredStrategiesItem(String preferredStrategiesItem) {
        this.preferredStrategies.add(preferredStrategiesItem);
        return this;
    }

    public String getBinaryVersion() {
        return this.binaryVersion;
    }

    public void setBinaryVersion(String binaryVersion) {
        this.binaryVersion = binaryVersion;
    }

    public V1alpha1LeaseCandidateSpec binaryVersion(String binaryVersion) {
        this.binaryVersion = binaryVersion;
        return this;
    }

    public String getEmulationVersion() {
        return this.emulationVersion;
    }

    public void setEmulationVersion(String emulationVersion) {
        this.emulationVersion = emulationVersion;
    }

    public V1alpha1LeaseCandidateSpec emulationVersion(String emulationVersion) {
        this.emulationVersion = emulationVersion;
        return this;
    }

    public OffsetDateTime getPingTime() {
        return this.pingTime;
    }

    public void setPingTime(OffsetDateTime pingTime) {
        this.pingTime = pingTime;
    }

    public V1alpha1LeaseCandidateSpec pingTime(OffsetDateTime pingTime) {
        this.pingTime = pingTime;
        return this;
    }

    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public void setRenewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
    }

    public V1alpha1LeaseCandidateSpec renewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1LeaseCandidateSpec v1alpha1LeaseCandidateSpec = (V1alpha1LeaseCandidateSpec)o;
        return Objects.equals(this.leaseName, v1alpha1LeaseCandidateSpec.leaseName) && Objects.equals(this.preferredStrategies, v1alpha1LeaseCandidateSpec.preferredStrategies) && Objects.equals(this.binaryVersion, v1alpha1LeaseCandidateSpec.binaryVersion) && Objects.equals(this.emulationVersion, v1alpha1LeaseCandidateSpec.emulationVersion) && Objects.equals(this.pingTime, v1alpha1LeaseCandidateSpec.pingTime) && Objects.equals(this.renewTime, v1alpha1LeaseCandidateSpec.renewTime);
    }

    public int hashCode() {
        return Objects.hash(this.leaseName, this.preferredStrategies, this.binaryVersion, this.emulationVersion, this.pingTime, this.renewTime);
    }

    public String toString() {
        return "V1alpha1LeaseCandidateSpec(leaseName: " + this.getLeaseName() + ", preferredStrategies: " + this.getPreferredStrategies() + ", binaryVersion: " + this.getBinaryVersion() + ", emulationVersion: " + this.getEmulationVersion() + ", pingTime: " + this.getPingTime() + ", renewTime: " + this.getRenewTime() + ")";
    }
}

