/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"driverName", "apiVersion", "kind", "metadata", "parameters"})
public class V1alpha1VolumeAttributesClass
implements KubernetesObject {
    public static final String JSON_PROPERTY_DRIVER_NAME = "driverName";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    @NotNull
    @JsonProperty(value="driverName")
    private String driverName;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> parameters;

    public V1alpha1VolumeAttributesClass(String driverName) {
        this.driverName = driverName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public V1alpha1VolumeAttributesClass driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1VolumeAttributesClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha1VolumeAttributesClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha1VolumeAttributesClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, @NotNull String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, @NotNull String> parameters) {
        this.parameters = parameters;
    }

    public V1alpha1VolumeAttributesClass parameters(Map<String, @NotNull String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1alpha1VolumeAttributesClass putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1VolumeAttributesClass v1alpha1VolumeAttributesClass = (V1alpha1VolumeAttributesClass)o;
        return Objects.equals(this.driverName, v1alpha1VolumeAttributesClass.driverName) && Objects.equals(this.apiVersion, v1alpha1VolumeAttributesClass.apiVersion) && Objects.equals(this.kind, v1alpha1VolumeAttributesClass.kind) && Objects.equals(this.metadata, v1alpha1VolumeAttributesClass.metadata) && Objects.equals(this.parameters, v1alpha1VolumeAttributesClass.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.driverName, this.apiVersion, this.kind, this.metadata, this.parameters);
    }

    public String toString() {
        return "V1alpha1VolumeAttributesClass(driverName: " + this.getDriverName() + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + this.getMetadata() + ", parameters: " + this.getParameters() + ")";
    }
}

