/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1NodeSelector;
import io.micronaut.kubernetes.client.openapi.model.V1alpha3Device;
import io.micronaut.kubernetes.client.openapi.model.V1alpha3ResourcePool;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"driver", "pool", "allNodes", "devices", "nodeName", "nodeSelector"})
public class V1alpha3ResourceSliceSpec {
    public static final String JSON_PROPERTY_DRIVER = "driver";
    public static final String JSON_PROPERTY_POOL = "pool";
    public static final String JSON_PROPERTY_ALL_NODES = "allNodes";
    public static final String JSON_PROPERTY_DEVICES = "devices";
    public static final String JSON_PROPERTY_NODE_NAME = "nodeName";
    public static final String JSON_PROPERTY_NODE_SELECTOR = "nodeSelector";
    @NotNull
    @JsonProperty(value="driver")
    private String driver;
    @NotNull
    @Valid
    @JsonProperty(value="pool")
    private V1alpha3ResourcePool pool;
    @Nullable
    @JsonProperty(value="allNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean allNodes;
    @Nullable
    @JsonProperty(value="devices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1alpha3Device> devices;
    @Nullable
    @JsonProperty(value="nodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String nodeName;
    @Nullable
    @Valid
    @JsonProperty(value="nodeSelector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1NodeSelector nodeSelector;

    public V1alpha3ResourceSliceSpec(String driver, V1alpha3ResourcePool pool) {
        this.driver = driver;
        this.pool = pool;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1alpha3ResourceSliceSpec driver(String driver) {
        this.driver = driver;
        return this;
    }

    public V1alpha3ResourcePool getPool() {
        return this.pool;
    }

    public void setPool(V1alpha3ResourcePool pool) {
        this.pool = pool;
    }

    public V1alpha3ResourceSliceSpec pool(V1alpha3ResourcePool pool) {
        this.pool = pool;
        return this;
    }

    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1alpha3ResourceSliceSpec allNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    public List<@Valid V1alpha3Device> getDevices() {
        return this.devices;
    }

    public void setDevices(List<@Valid V1alpha3Device> devices) {
        this.devices = devices;
    }

    public V1alpha3ResourceSliceSpec devices(List<@Valid V1alpha3Device> devices) {
        this.devices = devices;
        return this;
    }

    public V1alpha3ResourceSliceSpec addDevicesItem(V1alpha3Device devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<V1alpha3Device>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1alpha3ResourceSliceSpec nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1alpha3ResourceSliceSpec nodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceSliceSpec v1alpha3ResourceSliceSpec = (V1alpha3ResourceSliceSpec)o;
        return Objects.equals(this.driver, v1alpha3ResourceSliceSpec.driver) && Objects.equals(this.pool, v1alpha3ResourceSliceSpec.pool) && Objects.equals(this.allNodes, v1alpha3ResourceSliceSpec.allNodes) && Objects.equals(this.devices, v1alpha3ResourceSliceSpec.devices) && Objects.equals(this.nodeName, v1alpha3ResourceSliceSpec.nodeName) && Objects.equals(this.nodeSelector, v1alpha3ResourceSliceSpec.nodeSelector);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.pool, this.allNodes, this.devices, this.nodeName, this.nodeSelector);
    }

    public String toString() {
        return "V1alpha3ResourceSliceSpec(driver: " + this.getDriver() + ", pool: " + this.getPool() + ", allNodes: " + this.getAllNodes() + ", devices: " + this.getDevices() + ", nodeName: " + this.getNodeName() + ", nodeSelector: " + this.getNodeSelector() + ")";
    }
}

