/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V2CrossVersionObjectReference;
import io.micronaut.kubernetes.client.openapi.model.V2HorizontalPodAutoscalerBehavior;
import io.micronaut.kubernetes.client.openapi.model.V2MetricSpec;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"maxReplicas", "scaleTargetRef", "behavior", "metrics", "minReplicas"})
public class V2HorizontalPodAutoscalerSpec {
    public static final String JSON_PROPERTY_MAX_REPLICAS = "maxReplicas";
    public static final String JSON_PROPERTY_SCALE_TARGET_REF = "scaleTargetRef";
    public static final String JSON_PROPERTY_BEHAVIOR = "behavior";
    public static final String JSON_PROPERTY_METRICS = "metrics";
    public static final String JSON_PROPERTY_MIN_REPLICAS = "minReplicas";
    @NotNull
    @JsonProperty(value="maxReplicas")
    private Integer maxReplicas;
    @NotNull
    @Valid
    @JsonProperty(value="scaleTargetRef")
    private V2CrossVersionObjectReference scaleTargetRef;
    @Nullable
    @Valid
    @JsonProperty(value="behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V2HorizontalPodAutoscalerBehavior behavior;
    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V2MetricSpec> metrics;
    @Nullable
    @JsonProperty(value="minReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReplicas;

    public V2HorizontalPodAutoscalerSpec(Integer maxReplicas, V2CrossVersionObjectReference scaleTargetRef) {
        this.maxReplicas = maxReplicas;
        this.scaleTargetRef = scaleTargetRef;
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public V2HorizontalPodAutoscalerSpec maxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    public V2CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(V2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public V2HorizontalPodAutoscalerSpec scaleTargetRef(V2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
        return this;
    }

    public V2HorizontalPodAutoscalerBehavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(V2HorizontalPodAutoscalerBehavior behavior) {
        this.behavior = behavior;
    }

    public V2HorizontalPodAutoscalerSpec behavior(V2HorizontalPodAutoscalerBehavior behavior) {
        this.behavior = behavior;
        return this;
    }

    public List<@Valid V2MetricSpec> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<@Valid V2MetricSpec> metrics) {
        this.metrics = metrics;
    }

    public V2HorizontalPodAutoscalerSpec metrics(List<@Valid V2MetricSpec> metrics) {
        this.metrics = metrics;
        return this;
    }

    public V2HorizontalPodAutoscalerSpec addMetricsItem(V2MetricSpec metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<V2MetricSpec>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public V2HorizontalPodAutoscalerSpec minReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerSpec v2HorizontalPodAutoscalerSpec = (V2HorizontalPodAutoscalerSpec)o;
        return Objects.equals(this.maxReplicas, v2HorizontalPodAutoscalerSpec.maxReplicas) && Objects.equals(this.scaleTargetRef, v2HorizontalPodAutoscalerSpec.scaleTargetRef) && Objects.equals(this.behavior, v2HorizontalPodAutoscalerSpec.behavior) && Objects.equals(this.metrics, v2HorizontalPodAutoscalerSpec.metrics) && Objects.equals(this.minReplicas, v2HorizontalPodAutoscalerSpec.minReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.scaleTargetRef, this.behavior, this.metrics, this.minReplicas);
    }

    public String toString() {
        return "V2HorizontalPodAutoscalerSpec(maxReplicas: " + this.getMaxReplicas() + ", scaleTargetRef: " + this.getScaleTargetRef() + ", behavior: " + this.getBehavior() + ", metrics: " + this.getMetrics() + ", minReplicas: " + this.getMinReplicas() + ")";
    }
}

