/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V2HorizontalPodAutoscalerCondition;
import io.micronaut.kubernetes.client.openapi.model.V2MetricStatus;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"desiredReplicas", "conditions", "currentMetrics", "currentReplicas", "lastScaleTime", "observedGeneration"})
public class V2HorizontalPodAutoscalerStatus {
    public static final String JSON_PROPERTY_DESIRED_REPLICAS = "desiredReplicas";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_CURRENT_METRICS = "currentMetrics";
    public static final String JSON_PROPERTY_CURRENT_REPLICAS = "currentReplicas";
    public static final String JSON_PROPERTY_LAST_SCALE_TIME = "lastScaleTime";
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    @NotNull
    @JsonProperty(value="desiredReplicas")
    private Integer desiredReplicas;
    @Nullable
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V2HorizontalPodAutoscalerCondition> conditions;
    @Nullable
    @JsonProperty(value="currentMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V2MetricStatus> currentMetrics;
    @Nullable
    @JsonProperty(value="currentReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer currentReplicas;
    @Nullable
    @JsonProperty(value="lastScaleTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'")
    private OffsetDateTime lastScaleTime;
    @Nullable
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long observedGeneration;

    public V2HorizontalPodAutoscalerStatus(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public V2HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    public List<@Valid V2HorizontalPodAutoscalerCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<@Valid V2HorizontalPodAutoscalerCondition> conditions) {
        this.conditions = conditions;
    }

    public V2HorizontalPodAutoscalerStatus conditions(List<@Valid V2HorizontalPodAutoscalerCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V2HorizontalPodAutoscalerStatus addConditionsItem(V2HorizontalPodAutoscalerCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V2HorizontalPodAutoscalerCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public List<@Valid V2MetricStatus> getCurrentMetrics() {
        return this.currentMetrics;
    }

    public void setCurrentMetrics(List<@Valid V2MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
    }

    public V2HorizontalPodAutoscalerStatus currentMetrics(List<@Valid V2MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
        return this;
    }

    public V2HorizontalPodAutoscalerStatus addCurrentMetricsItem(V2MetricStatus currentMetricsItem) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<V2MetricStatus>();
        }
        this.currentMetrics.add(currentMetricsItem);
        return this;
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V2HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public V2HorizontalPodAutoscalerStatus lastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V2HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerStatus v2HorizontalPodAutoscalerStatus = (V2HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.desiredReplicas, v2HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.conditions, v2HorizontalPodAutoscalerStatus.conditions) && Objects.equals(this.currentMetrics, v2HorizontalPodAutoscalerStatus.currentMetrics) && Objects.equals(this.currentReplicas, v2HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.lastScaleTime, v2HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, v2HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.desiredReplicas, this.conditions, this.currentMetrics, this.currentReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        return "V2HorizontalPodAutoscalerStatus(desiredReplicas: " + this.getDesiredReplicas() + ", conditions: " + this.getConditions() + ", currentMetrics: " + this.getCurrentMetrics() + ", currentReplicas: " + this.getCurrentReplicas() + ", lastScaleTime: " + this.getLastScaleTime() + ", observedGeneration: " + this.getObservedGeneration() + ")";
    }
}

