/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.util;

import io.micronaut.core.annotation.Internal;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
@Singleton
public class ThreadFactoryUtil {
    private final ThreadFactory threadFactory;

    ThreadFactoryUtil(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getNamedThreadFactory(String format) {
        AtomicInteger threadNumber = new AtomicInteger(1);
        return r -> {
            Thread thread = this.threadFactory.newThread(r);
            thread.setName(String.format(format, threadNumber.getAndIncrement()));
            return thread;
        };
    }
}

