/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.binders.NettyBodyAnnotationBinder;
import io.micronaut.http.server.netty.binders.NettyCompletableFutureBodyBinder;
import io.micronaut.http.server.netty.binders.NettyCompletedFileUploadBinder;
import io.micronaut.http.server.netty.binders.NettyInputStreamBodyBinder;
import io.micronaut.http.server.netty.binders.NettyPartUploadAnnotationBinder;
import io.micronaut.http.server.netty.binders.NettyPublisherBodyBinder;
import io.micronaut.http.server.netty.binders.NettyPublisherPartUploadBinder;
import io.micronaut.http.server.netty.binders.NettyStreamingFileUploadBinder;
import io.micronaut.http.server.netty.multipart.MultipartBodyArgumentBinder;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

@Internal
@Singleton
@Order(value=100)
public final class NettyServerRequestBinderRegistry
implements RequestBinderRegistry {
    private final DefaultRequestBinderRegistry internalRequestBinderRegistry;

    public NettyServerRequestBinderRegistry(ConversionService conversionService, List<RequestArgumentBinder> binders, BeanLocator beanLocator, BeanProvider<HttpServerConfiguration> httpServerConfiguration, @Named(value="blocking") BeanProvider<ExecutorService> executorService, MessageBodyHandlerRegistry bodyHandlerRegistry) {
        NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder = new NettyBodyAnnotationBinder<Object>(conversionService, (HttpServerConfiguration)httpServerConfiguration.get(), bodyHandlerRegistry);
        this.internalRequestBinderRegistry = new DefaultRequestBinderRegistry(conversionService, binders, nettyBodyAnnotationBinder);
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)new NettyCompletableFutureBodyBinder(nettyBodyAnnotationBinder));
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)new NettyPublisherBodyBinder(nettyBodyAnnotationBinder));
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)new MultipartBodyArgumentBinder(beanLocator, httpServerConfiguration));
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)new NettyInputStreamBodyBinder());
        NettyStreamingFileUpload.Factory fileUploadFactory = new NettyStreamingFileUpload.Factory(((HttpServerConfiguration)httpServerConfiguration.get()).getMultipart(), (ExecutorService)executorService.get());
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)new NettyStreamingFileUploadBinder(fileUploadFactory));
        NettyCompletedFileUploadBinder completedFileUploadBinder = new NettyCompletedFileUploadBinder(conversionService);
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)completedFileUploadBinder);
        NettyPublisherPartUploadBinder publisherPartUploadBinder = new NettyPublisherPartUploadBinder(conversionService, fileUploadFactory);
        this.internalRequestBinderRegistry.addArgumentBinder((ArgumentBinder)publisherPartUploadBinder);
        NettyPartUploadAnnotationBinder partUploadAnnotationBinder = new NettyPartUploadAnnotationBinder(conversionService, completedFileUploadBinder, publisherPartUploadBinder);
        this.internalRequestBinderRegistry.addArgumentBinder(partUploadAnnotationBinder);
        this.internalRequestBinderRegistry.addUnmatchedRequestArgumentBinder(partUploadAnnotationBinder);
    }

    public <T> void addArgumentBinder(ArgumentBinder<T, HttpRequest<?>> binder) {
        this.internalRequestBinderRegistry.addArgumentBinder(binder);
    }

    public <T> Optional<ArgumentBinder<T, HttpRequest<?>>> findArgumentBinder(Argument<T> argument) {
        return this.internalRequestBinderRegistry.findArgumentBinder(argument);
    }
}

