/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.websocket;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.netty.websocket.AbstractNettyWebSocketHandler;
import io.micronaut.http.netty.websocket.NettyWebSocketSession;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.CoroutineHelper;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodReference;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.scheduling.executor.ThreadSelection;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketPongMessage;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.bind.WebSocketState;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.event.WebSocketMessageProcessedEvent;
import io.micronaut.websocket.event.WebSocketSessionClosedEvent;
import io.micronaut.websocket.event.WebSocketSessionOpenEvent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Internal
public class NettyServerWebSocketHandler
extends AbstractNettyWebSocketHandler {
    public static final String ID = "websocket-handler";
    private final NettyWebSocketSession serverSession;
    private final NettyEmbeddedServices nettyEmbeddedServices;
    @Nullable
    private final CoroutineHelper coroutineHelper;
    private final Argument<?> bodyArgument;
    private final Argument<?> pongArgument;
    private final ThreadSelection threadSelection;
    private final ExecutorSelector executorSelector;

    NettyServerWebSocketHandler(NettyEmbeddedServices nettyEmbeddedServices, WebSocketSessionRepository webSocketSessionRepository, WebSocketServerHandshaker handshaker, WebSocketBean<?> webSocketBean, HttpRequest<?> request, UriRouteMatch<Object, Object> routeMatch, ChannelHandlerContext ctx, ThreadSelection threadSelection, ExecutorSelector executorSelector, @Nullable CoroutineHelper coroutineHelper) {
        block14: {
            List unboundArguments;
            BoundExecutable bound;
            super(ctx, nettyEmbeddedServices.getRequestArgumentSatisfier().getBinderRegistry(), nettyEmbeddedServices.getMediaTypeCodecRegistry(), webSocketBean, request, routeMatch.getVariableValues(), handshaker.version(), handshaker.selectedSubprotocol(), webSocketSessionRepository, nettyEmbeddedServices.getApplicationContext().getConversionService());
            this.threadSelection = threadSelection;
            this.executorSelector = executorSelector;
            this.serverSession = this.createWebSocketSession(ctx);
            DefaultExecutableBinder binder = new DefaultExecutableBinder();
            if (this.messageHandler != null) {
                bound = binder.tryBind((Executable)this.messageHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)this.serverSession, this.originatingRequest));
                unboundArguments = bound.getUnboundArguments();
                if (unboundArguments.size() == 1) {
                    this.bodyArgument = (Argument)unboundArguments.iterator().next();
                } else {
                    this.bodyArgument = null;
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("WebSocket @OnMessage method " + webSocketBean.getTarget() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 message parameter, but found 2 possible candidates: " + unboundArguments);
                    }
                    if (this.serverSession.isOpen()) {
                        this.serverSession.close(CloseReason.INTERNAL_ERROR);
                    }
                }
            } else {
                this.bodyArgument = null;
            }
            if (this.pongHandler != null) {
                bound = binder.tryBind((Executable)this.pongHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)this.serverSession, this.originatingRequest));
                unboundArguments = bound.getUnboundArguments();
                if (unboundArguments.size() == 1 && ((Argument)unboundArguments.get(0)).isAssignableFrom(WebSocketPongMessage.class)) {
                    this.pongArgument = (Argument)unboundArguments.get(0);
                } else {
                    this.pongArgument = null;
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("WebSocket @OnMessage pong handler method " + webSocketBean.getTarget() + "." + this.pongHandler.getExecutableMethod() + " should define exactly 1 message parameter assignable from a WebSocketPongMessage, but found: " + unboundArguments);
                    }
                    if (this.serverSession.isOpen()) {
                        this.serverSession.close(CloseReason.INTERNAL_ERROR);
                    }
                }
            } else {
                this.pongArgument = null;
            }
            this.nettyEmbeddedServices = nettyEmbeddedServices;
            this.coroutineHelper = coroutineHelper;
            request.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, routeMatch);
            Flux.from((Publisher)this.callOpenMethod(ctx)).subscribe(v -> {}, t -> this.forwardErrorToUser(ctx, e -> {
                if (this.LOG.isErrorEnabled()) {
                    this.LOG.error("Error Opening WebSocket [" + webSocketBean + "]: " + e.getMessage(), e);
                }
            }, (Throwable)t));
            ApplicationEventPublisher<WebSocketSessionOpenEvent> eventPublisher = nettyEmbeddedServices.getEventPublisher(WebSocketSessionOpenEvent.class);
            try {
                eventPublisher.publishEvent((Object)new WebSocketSessionOpenEvent((WebSocketSession)this.serverSession));
            }
            catch (Exception e) {
                if (!this.LOG.isErrorEnabled()) break block14;
                this.LOG.error("Error publishing WebSocket opened event: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public NettyWebSocketSession getSession() {
        return this.serverSession;
    }

    public Argument<?> getBodyArgument() {
        return this.bodyArgument;
    }

    public Argument<?> getPongArgument() {
        return this.pongArgument;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.writeCloseFrameAndTerminate(ctx, CloseReason.GOING_AWAY);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public boolean acceptInboundMessage(Object msg) {
        return msg instanceof WebSocketFrame;
    }

    protected NettyWebSocketSession createWebSocketSession(final ChannelHandlerContext ctx) {
        String id = (String)this.originatingRequest.getHeaders().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY);
        Channel channel = ctx.channel();
        NettyWebSocketSession session = new NettyWebSocketSession(id, channel, this.originatingRequest, this.mediaTypeCodecRegistry, this.webSocketVersion.toHttpHeaderValue(), ctx.pipeline().get(SslHandler.class) != null){
            private final ConvertibleValues<Object> uriVars;
            {
                super(id, channel, request, codecRegistry, protocolVersion, isSecure);
                this.uriVars = ConvertibleValues.of((Map)NettyServerWebSocketHandler.this.uriVariables);
            }

            public Optional<String> getSubprotocol() {
                return Optional.ofNullable(NettyServerWebSocketHandler.this.subProtocol);
            }

            public Set<? extends WebSocketSession> getOpenSessions() {
                return NettyServerWebSocketHandler.this.webSocketSessionRepository.getChannelGroup().stream().flatMap(ch -> {
                    NettyWebSocketSession s = (NettyWebSocketSession)ch.attr(NettyWebSocketSession.WEB_SOCKET_SESSION_KEY).get();
                    if (s != null && s.isOpen()) {
                        return Stream.of(s);
                    }
                    return Stream.empty();
                }).collect(Collectors.toSet());
            }

            public void close(CloseReason closeReason) {
                super.close(closeReason);
                NettyServerWebSocketHandler.this.webSocketSessionRepository.removeChannel(ctx.channel());
            }

            public Optional<Principal> getUserPrincipal() {
                return NettyServerWebSocketHandler.this.originatingRequest.getAttribute((CharSequence)HttpAttributes.PRINCIPAL, Principal.class);
            }

            public ConvertibleValues<Object> getUriVariables() {
                return this.uriVars;
            }
        };
        this.webSocketSessionRepository.addChannel(channel);
        return session;
    }

    protected Publisher<?> instrumentPublisher(ChannelHandlerContext ctx, Object result) {
        Publisher actual = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)result, Publisher.class);
        Publisher traced = subscriber -> ServerRequestContext.with((HttpRequest)this.originatingRequest, () -> actual.subscribe((Subscriber)new Subscriber<Object>(){

            public void onSubscribe(Subscription s) {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> subscriber.onSubscribe(s));
            }

            public void onNext(Object object) {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> subscriber.onNext(object));
            }

            public void onError(Throwable t) {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> subscriber.onError(t));
            }

            public void onComplete() {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> ((Subscriber)subscriber).onComplete());
            }
        }));
        return Flux.from((Publisher)traced).subscribeOn(Schedulers.fromExecutorService((ExecutorService)ctx.channel().eventLoop()));
    }

    protected Object invokeExecutable(BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> messageHandler) {
        ExecutableMethod executableMethod;
        Executable target;
        if (this.coroutineHelper != null && (target = boundExecutable.getTarget()) instanceof ExecutableMethod && (executableMethod = (ExecutableMethod)target).isSuspend()) {
            return Flux.deferContextual(ctx -> {
                try {
                    this.coroutineHelper.setupCoroutineContext(this.originatingRequest, ctx, PropagatedContext.getOrEmpty());
                    Object immediateReturnValue = this.invokeExecutable0(boundExecutable, messageHandler);
                    if (KotlinUtils.isKotlinCoroutineSuspended((Object)immediateReturnValue)) {
                        return Mono.fromCompletionStage((Supplier)ContinuationArgumentBinder.extractContinuationCompletableFutureSupplier((HttpRequest)this.originatingRequest));
                    }
                    return Mono.empty();
                }
                catch (Exception e) {
                    return Flux.error((Throwable)e);
                }
            });
        }
        return this.invokeExecutable0(boundExecutable, messageHandler);
    }

    private Object invokeExecutable0(BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> messageHandler) {
        return this.executorSelector.select((MethodReference)messageHandler.getExecutableMethod(), this.threadSelection).map(executorService -> {
            ReturnType returnType = messageHandler.getExecutableMethod().getReturnType();
            Mono result = returnType.isReactive() ? Mono.from((Publisher)((Publisher)boundExecutable.invoke(messageHandler.getTarget()))).contextWrite(reactorContext -> reactorContext.put((Object)"micronaut.http.server.request", (Object)this.originatingRequest)) : (returnType.isAsync() ? Mono.fromFuture(this.invokeWithContext(boundExecutable, messageHandler)) : Mono.fromSupplier(this.invokeWithContext(boundExecutable, messageHandler)));
            return result.subscribeOn(Schedulers.fromExecutor((Executor)executorService));
        }).orElseGet(this.invokeWithContext(boundExecutable, messageHandler));
    }

    private Supplier<?> invokeWithContext(BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> messageHandler) {
        return () -> ServerRequestContext.with((HttpRequest)this.originatingRequest, () -> boundExecutable.invoke(messageHandler.getTarget()));
    }

    protected void messageHandled(ChannelHandlerContext ctx, Object message) {
        ctx.executor().execute(() -> {
            block2: {
                try {
                    this.nettyEmbeddedServices.getEventPublisher(WebSocketMessageProcessedEvent.class).publishEvent((Object)new WebSocketMessageProcessedEvent((WebSocketSession)this.getSession(), message));
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) break block2;
                    this.LOG.error("Error publishing WebSocket message processed event: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        block3: {
            Channel channel = ctx.channel();
            channel.attr(NettyWebSocketSession.WEB_SOCKET_SESSION_KEY).set(null);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Removing WebSocket Server session: {}", (Object)this.serverSession);
            }
            this.webSocketSessionRepository.removeChannel(channel);
            try {
                this.nettyEmbeddedServices.getEventPublisher(WebSocketSessionClosedEvent.class).publishEvent((Object)new WebSocketSessionClosedEvent((WebSocketSession)this.serverSession));
            }
            catch (Exception e) {
                if (!this.LOG.isErrorEnabled()) break block3;
                this.LOG.error("Error publishing WebSocket closed event: " + e.getMessage(), (Throwable)e);
            }
        }
        super.handlerRemoved(ctx);
    }
}

