/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import java.util.Optional;

@Internal
public final class CorsUtil {
    private CorsUtil() {
    }

    public static boolean isPreflightRequest(HttpRequest<?> request) {
        HttpHeaders headers = request.getHeaders();
        Optional origin = request.getOrigin();
        return origin.isPresent() && headers.contains("Access-Control-Request-Method") && HttpMethod.OPTIONS == request.getMethod();
    }
}

