/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.JsonErrorResponseBodyProvider;
import io.micronaut.json.JsonConfiguration;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;

@Internal
@Singleton
@Requires(missingBeans={JsonErrorResponseBodyProvider.class})
final class DefaultJsonErrorResponseBodyProvider
implements JsonErrorResponseBodyProvider<JsonError> {
    private final boolean alwaysSerializeErrorsAsList;

    DefaultJsonErrorResponseBodyProvider(JsonConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    @Override
    public JsonError body(ErrorContext errorContext, HttpResponse<?> response) {
        JsonError error;
        if (!errorContext.hasErrors()) {
            error = new JsonError(response.reason());
        } else if (errorContext.getErrors().size() == 1 && !this.alwaysSerializeErrorsAsList) {
            Error jsonError = errorContext.getErrors().get(0);
            error = new JsonError(jsonError.getMessage());
            jsonError.getPath().ifPresent(arg_0 -> ((JsonError)error).path(arg_0));
        } else {
            error = new JsonError(response.reason());
            ArrayList<JsonError> errors = new ArrayList<JsonError>(errorContext.getErrors().size());
            for (Error jsonError : errorContext.getErrors()) {
                errors.add(new JsonError(jsonError.getMessage()).path((String)jsonError.getPath().orElse(null)));
            }
            error.embedded((CharSequence)"errors", errors);
        }
        try {
            error.link(Link.SELF, Link.of((URI)errorContext.getRequest().getUri()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return error;
    }
}

